unit MyMath1V2;
//=============================================================================
//       .
//           DELPHI
//  (c)  ..  1.2.  25.12.2009.
//=============================================================================
//     INTERFACE
//=============================================================================
interface
// ----------------------------------------------------------------------------
//    (EXP, SIN, COS, SI)    
// RqFunc := 'E';    EXP
// RqFunc := 'S';    SIN (RqX //  );
// RqFunc := 'C';    COS (RqX //  );
// RqFunc := 'I';     SI (RqX //  );
function TaylorFunc(RqFunc : char; RqX : double): double;

// ----------------------------------------------------------------------------
//  (  )    
//  (EXP, SIN, COS, SI)  
procedure TaylorCoeffToArray(RqFunc : char; var RqXArray : array of double);

// ----------------------------------------------------------------------------
//   Y  TaylorFunc(X),   Z  
//  , Y, Z    double   .
procedure TaylorFuncToYArray (RqFunc   : char;
                              RqXArray : array of double;
                              var RqYArray, RqZArray : array of double);
// ----------------------------------------------------------------------------
//    1.2.
//    ,   
//  KArray
function PPolynom (KArray : array of double; RqX : double):double;

//=============================================================================
//     IMPLEMENTATION
//=============================================================================
implementation


//    
const CoeffMaxNum = 31;
//     SIN  SI  
const SinCoeff : array [0..CoeffMaxNum] of integer =
 ( 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1,
   0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1
 );
//     COS  
const CosCoeff : array [0..CoeffMaxNum] of integer =
 ( 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0,
   1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0, 1, 0, -1, 0
 );

// ----------------------------------------------------------------------------
//    (EXP, SIN, COS, SI)    
function TaylorFunc(RqFunc : char; RqX : double): double;
var Ind       : integer;  //  
    Factorial : double;   //  
    XPower    : double;   //   RqX
begin
 Result    := 0;  //    
 Ind       := 0;  //  
 Factorial := 1;  //   
 XPower    := 1;  // RqX   
 repeat
    case UpCase(RqFunc)of
      'E' : begin   //   EXP
               Result := Result + XPower / Factorial;
            end;
      'S' : begin   //   SIN
               case SinCoeff[Ind] of
               - 1 : Result := Result - XPower / Factorial;
                 1 : Result := Result + XPower / Factorial;
               end;
            end;
      'C' : begin   //   COS
               case CosCoeff[Ind] of
               - 1 : Result := Result - XPower / Factorial;
                 1 : Result := Result + XPower / Factorial;
               end;
            end;
      'I' : begin   //   SI ( )
               case SinCoeff[Ind] of
               - 1 : Result := Result - XPower / Factorial / Ind;
                 1 : Result := Result + XPower / Factorial / Ind;
               end;
            end;
    end;
    //   (    )
    //   (Ind),  (Factorial)
    //      Ind (XPower)
    Ind := Ind + 1;                 //  
    Factorial := Factorial * Ind;   // 
    XPower    := XPower * RqX;      //    Ind
 until (Ind > CoeffMaxNum);
end; // of function

// ----------------------------------------------------------------------------
//  (  )    
//  (EXP, SIN, COS, SI)  
procedure TaylorCoeffToArray(RqFunc : char; var RqXArray : array of double);
var IndT        : integer;  //   ()   
    IndP        : integer;  //  ()  
    Factorial   : double;   //  
begin
 //     
 for IndP:= Low(RqXArray) to High(RqXArray) do RqXArray[IndP] := 0;
 //   
 IndT         := 0;  //    
 IndP         := 0;  //   
 Factorial    := 1;  //   

 repeat
    case UpCase(RqFunc)of
      'E' : begin   //    EXP
               RqXArray[IndP] := 1 / Factorial;
            end;
      'S' : begin   //    SIN
               case SinCoeff[IndT] of
               - 1 : RqXArray[IndP] :=  - 1 / Factorial;
                 1 : RqXArray[IndP] :=    1 / Factorial;
               end;
            end;
      'C' : begin   //    COS
               case CosCoeff[IndT] of
               - 1 : RqXArray[IndP] :=  - 1 / Factorial;
                 1 : RqXArray[IndP] :=    1 / Factorial;
               end;
            end;
      'I' : begin   //    SI ( )
               case SinCoeff[IndT] of
               - 1 : RqXArray[IndP] := - 1 / Factorial / IndT;
                 1 : RqXArray[IndP] :=   1 / Factorial / IndT;
               end;
            end;
    end;
    //   (    )
    //     (IndT, IndP),  
    //   (Factorial)
    IndT := IndT + 1;                //    
    IndP := IndP + 1;                //   
    Factorial := Factorial * IndT;   // 

 until (IndT > CoeffMaxNum) or (IndP > High(RqXArray));
end; // of function


// ----------------------------------------------------------------------------
//   Y  TaylorFunc(X),   Z  
//  , Y, Z        .
procedure TaylorFuncToYArray (RqFunc   : char;
                              RqXArray : array of double;
                              var RqYArray, RqZArray : array of double);
var Ind  : integer;  //  
begin
 for Ind:= Low(RqXArray) to High(RqXArray) do
 begin
   case RqFunc of
   'E' : begin
            //   EXP
            RqYArray[Ind] := TaylorFunc(RqFunc, RqXArray[Ind]);
            //      
            RqZArray[Ind] := RqYArray[Ind] - EXP(RqXArray[Ind]);
         end;
   'S' : begin
            //   SIN
            RqYArray[Ind] := TaylorFunc(RqFunc, RqXArray[Ind]);
            //      
            RqZArray[Ind] := RqYArray[Ind] - SIN(RqXArray[Ind]);
         end;
   'C' : begin
            //   COS
            RqYArray[Ind] := TaylorFunc(RqFunc, RqXArray[Ind]);
            //      
            RqZArray[Ind] := RqYArray[Ind] - COS(RqXArray[Ind]);
         end;
   'I' : begin
            //   SI ( )
            RqYArray[Ind] := TaylorFunc(RqFunc, RqXArray[Ind]);
            //  Delphi     
            RqZArray[Ind] := 0;
         end;
         else begin
            //     
            RqYArray[Ind] := 0;
            RqZArray[Ind] := 0;
         end;
   end;
   //      
   RqZArray[Ind] := RqYArray[Ind] - SIN(RqXArray[Ind]);
 end;
end;

// ----------------------------------------------------------------------------
//    ,   
//  KArray
function PPolynom (KArray : array of double; RqX : double):double;
var Ind    : integer;  //     
    Sum    : double;   //   
    PwX    : double;   // RqX   
begin
 Sum := 0;  //   
 PwX := 1;  // RqX   
 for Ind := Low(KArray) to High(KArray)
 do begin
   Sum := Sum + KArray[Ind] * PwX;   //     
   PwX := PwX * RqX;                 //  RqX   
 end;
 Result := Sum;                      //     RqX
end;


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

end.
